{*
 * Projecte Fressa a LINKAT
 * GLOBUS3
 *
 * @author Jordi Lagares Roset "jlagares@xtec.cat - www.lagares.org"
 * amb el suport del Departament d'Educacio de la Generalitat de Catalunya
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details (see the LICENSE file).
 *}

unit UnitEntradaSo;

{************************************************}
INTERFACE
{************************************************}

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, MMSystem, UnitDadesGlobus2;

type
  TFormEntradaSo = class(TForm)
  private
    { Private declarations }
    procedure WMWIMDATA(var Msg: TMessage); message MM_WIM_DATA;
  public
    { Public declarations }
  end;

function IniciarDadesUnitEntradaSo(NumeroDeBytesDelBuffer:LongInt):boolean;
function EngegarProcesEntradaSo(HWindow:HWnd):integer;
function EntradaSo:integer;
procedure PararEntradaSo;
procedure FinalitzarEntradaSo;

var
  FormEntradaSo: TFormEntradaSo;

Const
  NumeroMaxDeSons = 10;

var
  So: array[0..NumeroMaxDeSons,1..BytesBufferMaxim] of Byte;
  NumeroBufer:byte;
  BytesBuffer:integer;
  MessageString1,MessageString2,MessageString3,MessageString4,MessageString5,MessageString6,MessageString7: string;

{************************************************}
IMPLEMENTATION
{************************************************}

uses UnitFormIntensitatDurada;

{$R *.DFM}

var
  Cabecera: array[0..NumeroMaxDeSons] of TWaveHdr;
  Entrada:HWAVEIN;
  TPCMFormato:TWaveFormatEx;
  BoolPararEntradaDades:boolean;
  Canales,Bits:integer;

function IniciarDadesUnitEntradaSo(NumeroDeBytesDelBuffer:LongInt):boolean;
var
  i,n:integer;
begin
  For n:=0 to NumeroMaxDeSons do For i:=1 to BytesBufferMaxim do so[n,i]:=0;
  IniciarDadesUnitEntradaSo:=true;
  BytesBuffer:=NumeroDeBytesDelBuffer;
  Canales:=1;
  Muestras:=11025;
  //Muestras:=16000;
  //Muestras:=22050;
  //Muestras:=44100;
  Bits:=8;
  TPCMFormato.wFormatTag:= WAVE_FORMAT_PCM;
  TPCMFormato.nChannels:=Canales;
  TPCMFormato.nSamplesPerSec:=Muestras;
  TPCMFormato.wBitsPerSample:=Bits;
  TPCMFormato.nAvgBytesPerSec:=Round(Muestras*(Bits/8)*Canales);
  TPCMFormato.nBlockAlign:=Round((Bits/8)*Canales);
  TPCMFormato.cbSize:=0;
  For n:=0 to NumeroMaxDeSons do begin
    Cabecera[n].dwFlags:=0;
    Cabecera[n].lpData:=@(So[n,1]);
    Cabecera[n].dwBufferLength:=BytesBuffer;
  end;
  Entrada:=0;
end;

function EngegarProcesEntradaSo(HWindow:HWnd):integer;
var
  n,Rerror:integer;
begin
  EngegarProcesEntradaSo:=0;
  if Entrada<>0 then exit;
  Rerror:=waveInOpen(@Entrada, 0,@TPCMFormato,HWindow, 0, CALLBACK_WINDOW);
  if Rerror<>0 then begin
    EngegarProcesEntradaSo:=Rerror;
    MessageBox(FormEntradaSo.Handle,PChar(MessageString1),'Globus 2', mb_Ok or MB_ICONSTOP);
    Exit;
  end;
  BoolPararEntradaDades:=false;
  For n:=0 to NumeroMaxDeSons do begin
    waveInPrepareHeader(Entrada,@Cabecera[n],sizeof(TWaveHdr));
  end;
  waveInAddBuffer(Entrada,@Cabecera[0],sizeof(TWaveHdr));
  NumeroBufer:=0;
  waveInAddBuffer(Entrada,@Cabecera[1],sizeof(TWaveHdr));
  waveInStart(Entrada);
end;

function EntradaSo:integer;
var
  Rerror:integer;
begin
  if BoolPararEntradaDades then exit;
  Rerror:=waveInAddBuffer(Entrada,@Cabecera[(NumeroBufer+2) mod NumeroMaxDeSons],sizeof(TWaveHdr));
  //if Rerror<>MMSYSERR_NOERROR then ShowMessage('1.2, Error n'+IntToStr(RError));
  NumeroBufer:=(NumeroBufer+1) mod NumeroMaxDeSons;
end;

procedure PararEntradaSo;
begin
  BoolPararEntradaDades:=true;
  waveInReset(Entrada);
  waveInClose(Entrada);
  Entrada:=0;
end;

procedure FinalitzarEntradaSo;
begin
  //Dispose(So);
end;

procedure TFormEntradaSo.WMWIMDATA(var Msg: TMessage);
begin
  //DadesArribades
  //For i:=1 to BytesBuffer do if so[NumeroBufer,i]>Max then Max:=so^[NumeroBufer,i];
  EntradaSo;
end;

begin
  Muestras:=11025;
end.
